<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default" style="border-radius: 15px; overflow: hidden; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
                <div class="panel-heading" style="background: linear-gradient(135deg, #00cc33, #00ff44); color: white; padding: 20px;">
                    <h3 class="panel-title" style="font-size: 24px; font-weight: 700; margin: 0;">
                        <i class="fas fa-comments"></i> Live Chat Support
                    </h3>
                    <p style="margin: 10px 0 0 0; opacity: 0.9;">Get instant help from our support team</p>
                </div>
                <div class="panel-body" style="padding: 0; min-height: 600px; background: #f8f9fa;">
                    
                    <!-- Welcome Message -->
                    <div style="padding: 30px; text-align: center; background: white; border-bottom: 2px solid #e9ecef;">
                        <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #00cc33, #00ff44); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 5px 20px rgba(0,204,51,0.3);">
                            <i class="fas fa-headset" style="font-size: 40px; color: white;"></i>
                        </div>
                        <h4 style="color: #333; margin-bottom: 10px;">Welcome, {$client_name}!</h4>
                        <p style="color: #666; margin: 0;">Start a conversation with our support team. We're here to help you 24/7.</p>
                    </div>
                    
                    <!-- Chat Widget Container -->
                    <div id="multichat-widget-container" style="min-height: 500px; padding: 20px;">
                        <div style="text-align: center; padding: 50px 20px;">
                            <div class="spinner-border text-success" role="status" style="width: 3rem; height: 3rem;">
                                <span class="sr-only">Loading chat...</span>
                            </div>
                            <p style="margin-top: 20px; color: #666;">Loading chat widget...</p>
                        </div>
                    </div>
                    
                </div>
            </div>
            
            <!-- Help Cards -->
            <div class="row" style="margin-top: 30px;">
                <div class="col-md-4">
                    <div class="panel panel-default">
                        <div class="panel-body text-center">
                            <i class="fas fa-book" style="font-size: 40px; color: #00cc33; margin-bottom: 15px;"></i>
                            <h4>Knowledge Base</h4>
                            <p style="color: #666;">Browse our documentation</p>
                            <a href="knowledgebase.php" class="btn btn-default">View Articles</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="panel panel-default">
                        <div class="panel-body text-center">
                            <i class="fas fa-ticket-alt" style="font-size: 40px; color: #00cc33; margin-bottom: 15px;"></i>
                            <h4>Support Tickets</h4>
                            <p style="color: #666;">View your open tickets</p>
                            <a href="supporttickets.php" class="btn btn-default">My Tickets</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="panel panel-default">
                        <div class="panel-body text-center">
                            <i class="fas fa-phone" style="font-size: 40px; color: #00cc33; margin-bottom: 15px;"></i>
                            <h4>Emergency Contact</h4>
                            <p style="color: #666;">Need urgent assistance?</p>
                            <a href="contact.php" class="btn btn-default">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Load MultiChat Widget -->
<script>
(function() {
    var script = document.createElement('script');
    script.src = '{$multichat_url}/app/widget.js';
    script.setAttribute('data-bubble-key', '{$bubble_key}');
    script.setAttribute('data-whmcs-client-id', '{$client_id}');
    script.setAttribute('data-prefill-email', '{$client_email}');
    script.setAttribute('data-prefill-name', '{$client_name}');
    script.setAttribute('data-auto-identify', 'true');
    script.setAttribute('data-skip-form', 'true');
    script.setAttribute('data-inline', 'true');
    script.setAttribute('data-container', 'multichat-widget-container');
    document.head.appendChild(script);
    
    // Hide loading spinner when widget loads
    script.onload = function() {
        setTimeout(function() {
            var container = document.getElementById('multichat-widget-container');
            if (container) {
                container.innerHTML = '';
            }
        }, 1000);
    };
})();
</script>

<style>
.panel {
    transition: all 0.3s ease;
}
.panel:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
}
.btn-default {
    background: white;
    border: 2px solid #00cc33;
    color: #00cc33;
    font-weight: 600;
    transition: all 0.3s ease;
}
.btn-default:hover {
    background: #00cc33;
    border-color: #00cc33;
    color: white;
}
</style>
